<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * AllegroCategoryItemType
 *
 * @ORM\Table(name="allegro_category_item_type")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroCategoryItemTypeRepository")
 *
 * @ExclusionPolicy("all")
 */
class AllegroCategoryItemType
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $name;

    /**
     * @var string $symbol
     *
     * @ORM\Column(name="symbol", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"placeDetails","companyDetails", "simpleList"})
     */
    private $symbol;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategoryItem", mappedBy="type",cascade={"persist"})
     */
    private $items;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AllegroCategoryItemType
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add items
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $items
     * @return AllegroCategoryItemType
     */
    public function addItem(\Import\ApiBundle\Entity\AllegroCategoryItem $items)
    {
        $this->items[] = $items;
    
        return $this;
    }

    /**
     * Remove items
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $items
     */
    public function removeItem(\Import\ApiBundle\Entity\AllegroCategoryItem $items)
    {
        $this->items->removeElement($items);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return AllegroCategoryItemType
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }
}